/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class ShredsOfSanityEffect
extends OneShotEffect {
    ShredsOfSanityEffect() {
        super(Outcome.Benefit);
        this.staticText = "return up to one target instant card and up to one target sorcery card from your graveyard to your hand, then discard a card";
    }

    private ShredsOfSanityEffect(ShredsOfSanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShredsOfSanityEffect copy() {
        return new ShredsOfSanityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cardsToHand = new CardsImpl();
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null) {
                cardsToHand.add(card);
            }
            if ((card = game.getCard(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
                cardsToHand.add(card);
            }
            controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            controller.discardOne(false, false, source, game);
            return true;
        }
        return false;
    }
}

