/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ShrivelingRotDestroyTriggeredAbility
extends DelayedTriggeredAbility {
    ShrivelingRotDestroyTriggeredAbility() {
        super((Effect)new DestroyTargetEffect(), Duration.EndOfTurn, false);
    }

    private ShrivelingRotDestroyTriggeredAbility(ShrivelingRotDestroyTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public ShrivelingRotDestroyTriggeredAbility copy() {
        return new ShrivelingRotDestroyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }

    public String getRule() {
        return "Until end of turn, whenever a creature is dealt damage, destroy it.";
    }
}

