/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SibilantSpiritEffect
extends OneShotEffect {
    SibilantSpiritEffect() {
        super(Outcome.DrawCard);
        this.staticText = "defending player may draw a card";
    }

    private SibilantSpiritEffect(SibilantSpiritEffect effect) {
        super((OneShotEffect)effect);
    }

    public SibilantSpiritEffect copy() {
        return new SibilantSpiritEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defenderId = game.getCombat().getDefenderId(source.getSourceId());
        Player defender = game.getPlayer(defenderId);
        if (defender != null && defender.chooseUse(this.outcome, "Draw a card?", source, game)) {
            defender.drawCards(1, source, game);
        }
        return false;
    }
}

