/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.ReachAbility;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SidarKondoOfJamuraaCantBlockCreaturesSourceEffect
extends RestrictionEffect {
    private final FilterCreaturePermanent filter;

    SidarKondoOfJamuraaCantBlockCreaturesSourceEffect(FilterCreaturePermanent filter) {
        super(Duration.WhileOnBattlefield);
        this.filter = filter;
        this.staticText = "Creatures your opponents control without flying or reach can't block " + filter.getMessage();
    }

    private SidarKondoOfJamuraaCantBlockCreaturesSourceEffect(SidarKondoOfJamuraaCantBlockCreaturesSourceEffect effect) {
        super((RestrictionEffect)effect);
        this.filter = effect.filter;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.hasAbility((Ability)FlyingAbility.getInstance(), game) || permanent.hasAbility((Ability)ReachAbility.getInstance(), game)) {
            return false;
        }
        return game.getOpponents(source.getControllerId()).contains(permanent.getControllerId());
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        return !this.filter.match(attacker, source.getControllerId(), source, game);
    }

    public SidarKondoOfJamuraaCantBlockCreaturesSourceEffect copy() {
        return new SidarKondoOfJamuraaCantBlockCreaturesSourceEffect(this);
    }
}

