/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SigardasAidEffect
extends OneShotEffect {
    SigardasAidEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may attach it to target creature you control";
    }

    private SigardasAidEffect(SigardasAidEffect effect) {
        super((OneShotEffect)effect);
    }

    public SigardasAidEffect copy() {
        return new SigardasAidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent equipment = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            Permanent targetCreature = game.getPermanent(source.getTargets().getFirstTarget());
            if (equipment != null && targetCreature != null) {
                targetCreature.addAttachment(equipment.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

