/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturesWithDifferentPowers;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SigardasVanguardEffect
extends OneShotEffect {
    SigardasVanguardEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose any number of creatures with different powers. Those creatures gain double strike until end of turn";
    }

    private SigardasVanguardEffect(SigardasVanguardEffect effect) {
        super((OneShotEffect)effect);
    }

    public SigardasVanguardEffect copy() {
        return new SigardasVanguardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCreaturesWithDifferentPowers target = new TargetCreaturesWithDifferentPowers();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Cards)new CardsImpl((Collection)target.getTargets()), game)), source);
        return true;
    }
}

