/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class SigardianPaladinWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    SigardianPaladinWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.COUNTER_ADDED || this.playerSet.contains(event.getPlayerId()) || !event.getData().equals(CounterType.P1P1.getName())) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game)) {
            this.playerSet.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((SigardianPaladinWatcher)game.getState().getWatcher(SigardianPaladinWatcher.class)).playerSet.contains(playerId);
    }
}

