/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SigurdJarlOfRavensthorpeEffect
extends OneShotEffect {
    SigurdJarlOfRavensthorpeEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a lore counter on target Saga you control or remove one from it";
    }

    private SigurdJarlOfRavensthorpeEffect(SigurdJarlOfRavensthorpeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SigurdJarlOfRavensthorpeEffect copy() {
        return new SigurdJarlOfRavensthorpeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Add a lore counter to " + permanent.getIdName() + " or remove one?", null, "Add", "Remove", source, game)) {
            permanent.addCounters(CounterType.LORE.createInstance(), source, game);
        } else {
            permanent.removeCounters(CounterType.LORE.createInstance(), source, game);
        }
        return true;
    }
}

