/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class SilentHallcreeperEffect
extends OneShotEffect {
    SilentHallcreeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} becomes a copy of another target creature you control";
    }

    private SilentHallcreeperEffect(SilentHallcreeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public SilentHallcreeperEffect copy() {
        return new SilentHallcreeperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            game.copyPermanent(Duration.Custom, copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            return true;
        }
        return false;
    }
}

