/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetSpell;
import mage.target.common.TargetCreaturePermanent;

public final class SilumgarsCommand
extends CardImpl {
    private static final FilterPermanent filter2 = new FilterPermanent("planeswalker");

    public SilumgarsCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{U}{B}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().getEffects().add((Object)new CounterTargetEffect());
        this.getSpellAbility().getTargets().add((Target)new TargetSpell(StaticFilters.FILTER_SPELL_NON_CREATURE));
        Mode mode = new Mode((Effect)new ReturnToHandTargetEffect());
        mode.addTarget((Target)new TargetPermanent());
        this.getSpellAbility().getModes().addMode(mode);
        mode = new Mode((Effect)new BoostTargetEffect(-3, -3, Duration.EndOfTurn));
        mode.addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().getModes().addMode(mode);
        mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent(filter2));
        this.getSpellAbility().getModes().addMode(mode);
    }

    private SilumgarsCommand(SilumgarsCommand card) {
        super((CardImpl)card);
    }

    public SilumgarsCommand copy() {
        return new SilumgarsCommand(this);
    }

    static {
        filter2.add((Predicate)CardType.PLANESWALKER.getPredicate());
    }
}

