/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SimicAscendancyTriggeredAbility
extends TriggeredAbilityImpl {
    SimicAscendancyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.GROWTH.createInstance(), (DynamicValue)SavedDamageValue.MANY), false);
        this.setTriggerPhrase("Whenever one or more +1/+1 counters are put on a creature you control, ");
    }

    private SimicAscendancyTriggeredAbility(SimicAscendancyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SimicAscendancyTriggeredAbility copy() {
        return new SimicAscendancyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getData().equals(CounterType.P1P1.getName()) || event.getAmount() < 1) {
            return false;
        }
        Permanent permanent = Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).orElseGet(() -> game.getPermanentEntering(event.getTargetId()));
        if (permanent == null || event.getTargetId().equals(this.getSourceId()) || !permanent.isCreature(game) || !permanent.isControlledBy(this.getControllerId())) {
            return false;
        }
        this.getEffects().setValue("damage", (Object)event.getAmount());
        return true;
    }
}

