/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.MoveCounterTargetsEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.MoveAuraEffect;
import mage.cards.s.SameControllerPredicate;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.other.AnotherTargetPredicate;
import mage.filter.predicate.permanent.AttachedToPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class SimicGuildmage
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("another target creature with the same controller");
    private static final FilterPermanent auraFilter = new FilterPermanent(SubType.AURA, "Aura enchanting a permanent");

    public SimicGuildmage(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{G/U}{G/U}");
        this.subtype.add((Object)SubType.ELF);
        this.subtype.add((Object)SubType.WIZARD);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        SimpleActivatedAbility countersAbility = new SimpleActivatedAbility((Effect)new MoveCounterTargetsEffect(CounterType.P1P1), (Cost)new ManaCostsImpl("{1}{G}"));
        countersAbility.addTarget(new TargetCreaturePermanent().withChooseHint("to remove a counter from").setTargetTag(1));
        countersAbility.addTarget(new TargetPermanent(filter).withChooseHint("to move a counter to").setTargetTag(2));
        this.addAbility((Ability)countersAbility);
        SimpleActivatedAbility auraAbility = new SimpleActivatedAbility((Effect)new MoveAuraEffect(), (Cost)new ManaCostsImpl("{1}{U}"));
        auraAbility.addTarget((Target)new TargetPermanent(auraFilter));
        this.addAbility((Ability)auraAbility);
    }

    private SimicGuildmage(SimicGuildmage card) {
        super((CardImpl)card);
    }

    public SimicGuildmage copy() {
        return new SimicGuildmage(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)new AnotherTargetPredicate(2));
        filter.add((ObjectSourcePlayerPredicate)SameControllerPredicate.instance);
        auraFilter.add((ObjectSourcePlayerPredicate)new AttachedToPredicate(StaticFilters.FILTER_PERMANENT));
    }
}

