/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SinProdderEffect
extends OneShotEffect {
    SinProdderEffect() {
        super(Outcome.DrawCard);
        this.staticText = "reveal the top card of your library. Any opponent may have you put that card into your graveyard. If a player does, {this} deals damage to that player equal to that card's mana value. Otherwise, put that card into your hand";
    }

    private SinProdderEffect(SinProdderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SinProdderEffect copy() {
        return new SinProdderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                controller.revealCards(source, (Cards)new CardsImpl(card), game);
                String message = "Put " + card.getName() + " in " + controller.getName() + "'s graveyard?";
                boolean putInGraveyard = false;
                for (UUID opponentUuid : game.getOpponents(source.getControllerId())) {
                    Player opponent = game.getPlayer(opponentUuid);
                    if (opponent == null || putInGraveyard || !opponent.chooseUse(Outcome.Damage, message, source, game)) continue;
                    putInGraveyard = true;
                    opponent.damage(card.getManaValue(), source.getSourceId(), source, game);
                    break;
                }
                if (putInGraveyard) {
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                } else {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

