/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SingleCombatEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("creature or planeswalker you control (to keep)");

    SingleCombatEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player chooses a creature or planeswalker they control, then sacrifices the rest";
    }

    private SingleCombatEffect(SingleCombatEffect effect) {
        super((OneShotEffect)effect);
    }

    public SingleCombatEffect copy() {
        return new SingleCombatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterCreatureOrPlaneswalkerPermanent filterSac = new FilterCreatureOrPlaneswalkerPermanent();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            if (!player.choose(this.outcome, (Target)target, source, game)) continue;
            filterSac.add(Predicates.not((Predicate)new PermanentIdPredicate(target.getFirstTarget())));
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterSac, source.getControllerId(), game)) {
            permanent.sacrifice(source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

