/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SinisterConciergeEffect
extends OneShotEffect {
    public SinisterConciergeEffect() {
        super(Outcome.Removal);
        this.staticText = "exile it and put three time counters on it. If you do, exile up to one target creature and put three time counters on it. Each card exiled this way that doesn't have suspend gains suspend. <i>(For each card with suspend, its owner removes a time counter from it at the beginning of their upkeep. When the last is removed, they may cast it without paying its mana cost. Those creature spells have haste.)</i>";
    }

    private SinisterConciergeEffect(SinisterConciergeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (controller == null || card == null || card.getZoneChangeCounter(game) != source.getStackMomentSourceZCC() || !Zone.GRAVEYARD.match(game.getState().getZone(card.getId()))) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)3, (Ability)source, (Game)game);
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null) {
            controller.moveCards((Card)targetCreature, Zone.EXILED, source, game);
            SuspendAbility.addTimeCountersAndSuspend((Card)targetCreature.getMainCard(), (int)3, (Ability)source, (Game)game);
        }
        return true;
    }

    public SinisterConciergeEffect copy() {
        return new SinisterConciergeEffect(this);
    }
}

