/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SinisterWaltzEffect
extends OneShotEffect {
    SinisterWaltzEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose three target creature cards in your graveyard. Return two of them at random to the battlefield and put the other on the bottom of your library";
    }

    private SinisterWaltzEffect(SinisterWaltzEffect effect) {
        super((OneShotEffect)effect);
    }

    public SinisterWaltzEffect copy() {
        return new SinisterWaltzEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (cards.size() > 2) {
            card = cards.getRandom(game);
            cards.remove(card);
        } else {
            card = null;
        }
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        if (card != null) {
            player.putCardsOnBottomOfLibrary(card, game, source);
        }
        return true;
    }
}

