/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.HumanSoldierToken;
import mage.game.permanent.token.Token;

class SionaCaptainOfThePyleasAbility
extends TriggeredAbilityImpl {
    SionaCaptainOfThePyleasAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new HumanSoldierToken()), false);
    }

    private SionaCaptainOfThePyleasAbility(SionaCaptainOfThePyleasAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACHED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        Permanent attachment = game.getPermanent(event.getSourceId());
        return permanent != null && attachment != null && permanent.isControlledBy(this.getControllerId()) && permanent.isCreature(game) && attachment.isControlledBy(this.getControllerId()) && attachment.hasSubtype(SubType.AURA, game);
    }

    public String getRule() {
        return "Whenever an Aura you control becomes attached to a creature you control, create a 1/1 white Human Soldier creature token.";
    }

    public SionaCaptainOfThePyleasAbility copy() {
        return new SionaCaptainOfThePyleasAbility(this);
    }
}

