/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SireOfInsanityEffect
extends OneShotEffect {
    SireOfInsanityEffect() {
        super(Outcome.Discard);
        this.staticText = "each player discards their hand";
    }

    private SireOfInsanityEffect(SireOfInsanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        if (sourcePlayer == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.discard(player.getHand(), false, source, game);
        }
        return true;
    }

    public SireOfInsanityEffect copy() {
        return new SireOfInsanityEffect(this);
    }
}

