/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.common.ExileTargetForSourceEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderYourControlTargetEffect;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SirensRuseEffect
extends ExileTargetForSourceEffect {
    SirensRuseEffect() {
        this.staticText = "Exile target creature you control, then return that card to the battlefield under its owner's control. If a Pirate was exiled this way, draw a card.";
    }

    private SirensRuseEffect(SirensRuseEffect effect) {
        super((ExileTargetForSourceEffect)effect);
    }

    public SirensRuseEffect copy() {
        return new SirensRuseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean isPirate = false;
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.hasSubtype(SubType.PIRATE, game)) {
            isPirate = true;
        }
        if (super.apply(game, source)) {
            new ReturnToBattlefieldUnderYourControlTargetEffect(false).apply(game, source);
            if (isPirate && player != null) {
                player.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }
}

