/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInLibrary;

class SisayWeatherlightCaptainEffect
extends OneShotEffect {
    SisayWeatherlightCaptainEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a legendary permanent card with mana value less than {this}'s power, put that card onto the battlefield, then shuffle.";
    }

    private SisayWeatherlightCaptainEffect(SisayWeatherlightCaptainEffect effect) {
        super((OneShotEffect)effect);
    }

    public SisayWeatherlightCaptainEffect copy() {
        return new SisayWeatherlightCaptainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        FilterPermanentCard filter = new FilterPermanentCard("legendary permanent card with mana value less than " + power);
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, power));
        return new SearchLibraryPutInPlayEffect(new TargetCardInLibrary((FilterCard)filter)).apply(game, source);
    }
}

