/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

class SkipNextUntapStepSourceControllerEffect
extends OneShotEffect {
    SkipNextUntapStepSourceControllerEffect() {
        super(Outcome.Detriment);
        this.staticText = "Skip the untap step of that turn";
    }

    private SkipNextUntapStepSourceControllerEffect(SkipNextUntapStepSourceControllerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            game.getState().getTurnMods().add(new TurnMod(controller.getId()).withSkipStep(PhaseStep.UNTAP));
            return true;
        }
        return false;
    }

    public SkipNextUntapStepSourceControllerEffect copy() {
        return new SkipNextUntapStepSourceControllerEffect(this);
    }
}

