/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class SkirkDrillSergeantEffect
extends OneShotEffect {
    private static final FilterPermanentCard filter = new FilterPermanentCard("Goblin permanent card");

    public SkirkDrillSergeantEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "reveal the top card of your library. If it's a Goblin permanent card, put it onto the battlefield. Otherwise, put it into your graveyard";
    }

    private SkirkDrillSergeantEffect(SkirkDrillSergeantEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkirkDrillSergeantEffect copy() {
        return new SkirkDrillSergeantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        if (controller.getLibrary().hasCards()) {
            Card card = controller.getLibrary().getFromTop(game);
            controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
            if (card != null) {
                if (filter.match(card, game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                } else {
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                }
            }
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.GOBLIN.getPredicate());
    }
}

