/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class SkitteringCicadaBoostEffect
extends OneShotEffect {
    SkitteringCicadaBoostEffect() {
        super(Outcome.BoostCreature);
        this.staticText = " and gets +X/+X, where X is that spell's mana value";
    }

    private SkitteringCicadaBoostEffect(SkitteringCicadaBoostEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkitteringCicadaBoostEffect copy() {
        return new SkitteringCicadaBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            int cmc = spell.getManaValue();
            if (cmc > 0) {
                game.addEffect((ContinuousEffect)new BoostSourceEffect(cmc, cmc, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

