/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class SkullscorchDiscardEffect
extends OneShotEffect {
    SkullscorchDiscardEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target player discards two cards at random unless that player has {this} deal 4 damage to them";
    }

    private SkullscorchDiscardEffect(SkullscorchDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkullscorchDiscardEffect copy() {
        return new SkullscorchDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        StackObject spell = null;
        for (StackObject object : game.getStack()) {
            if (!(object instanceof Spell) || !object.getSourceId().equals(source.getSourceId())) continue;
            spell = object;
        }
        if (spell != null) {
            boolean discardCards = true;
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                if (player.chooseUse(Outcome.Detriment, "Have " + spell.getLogName() + " deal 4 damage to you?", source, game)) {
                    discardCards = false;
                    player.damage(4, source.getSourceId(), source, game);
                    game.informPlayers(player.getLogName() + " has " + spell.getLogName() + " deal 4 to them");
                }
                if (discardCards) {
                    player.discard(2, true, false, source, game);
                }
            }
            return discardCards;
        }
        return false;
    }
}

