/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetOpponent;

class SkullwinderEffect
extends OneShotEffect {
    SkullwinderEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then choose an opponent. That player returns a card from their graveyard to their hand";
    }

    private SkullwinderEffect(SkullwinderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkullwinderEffect copy() {
        return new SkullwinderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Player opponent;
            TargetOpponent targetOpponent = new TargetOpponent(true);
            if (controller.choose(Outcome.Detriment, (Target)targetOpponent, source, game) && (opponent = game.getPlayer(targetOpponent.getFirstTarget())) != null) {
                Card card;
                game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen " + opponent.getLogName());
                TargetCardInYourGraveyard targetCard = new TargetCardInYourGraveyard(new FilterCard("a card from your graveyard to return to your hand"));
                targetCard.withNotTarget(true);
                if (opponent.choose(this.outcome, (Target)targetCard, source, game) && (card = game.getCard(targetCard.getFirstTarget())) != null) {
                    opponent.moveCards(card, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

