/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.common.AttacksAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.SetTargetPointer;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SkyboonEvangelistTriggeredAbility
extends AttacksAllTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with a counter on it");

    SkyboonEvangelistTriggeredAbility() {
        super((Effect)new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn).setText("that creature gains flying until end of turn"), false, filter, SetTargetPointer.PERMANENT, false);
    }

    private SkyboonEvangelistTriggeredAbility(SkyboonEvangelistTriggeredAbility effect) {
        super((AttacksAllTriggeredAbility)effect);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            Player defender = game.getPlayer(event.getTargetId());
            if (defender == null) {
                return false;
            }
            Set opponents = game.getOpponents(this.getControllerId());
            if (opponents != null && opponents.contains(defender.getId())) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature with a counter on it attacks one of your opponents, that creature gains flying until end of turn.";
    }

    public SkyboonEvangelistTriggeredAbility copy() {
        return new SkyboonEvangelistTriggeredAbility(this);
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

