/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PartyCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class SkyclavePlunderEffect
extends OneShotEffect {
    SkyclavePlunderEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top X cards of your library, where X is three plus the number of creatures in your party. Put three of those cards into your hand and the rest on the bottom of your library in a random order. " + PartyCount.getReminder();
    }

    private SkyclavePlunderEffect(SkyclavePlunderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkyclavePlunderEffect copy() {
        return new SkyclavePlunderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = 3 + PartyCount.instance.calculate(game, source, (Effect)this);
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue));
        int toTake = Math.min(cards.size(), 3);
        TargetCardInLibrary target = new TargetCardInLibrary(toTake, toTake, StaticFilters.FILTER_CARD);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
        cards.removeIf(target.getTargets()::contains);
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

