/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SlaughterTheStrongEffect
extends OneShotEffect {
    SlaughterTheStrongEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player chooses any number of creatures they control with total power 4 or less, then sacrifices all other creatures they control";
    }

    private SlaughterTheStrongEffect(SlaughterTheStrongEffect effect) {
        super((OneShotEffect)effect);
    }

    public SlaughterTheStrongEffect copy() {
        return new SlaughterTheStrongEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                boolean selectionDone = false;
                HashSet<UUID> selectedCreatures = new HashSet<UUID>();
                while (player.canRespond() && !selectionDone) {
                    TargetPermanent target;
                    int powerSum = 0;
                    for (UUID creatureId : selectedCreatures) {
                        Permanent creature = game.getPermanent(creatureId);
                        if (creature == null) continue;
                        powerSum += creature.getPower().getValue();
                    }
                    FilterControlledCreaturePermanent currentFilter = new FilterControlledCreaturePermanent("any number of creatures you control with total power 4 or less (already selected total power " + powerSum + ")");
                    HashSet<PermanentIdPredicate> alreadySelectedCreatures = new HashSet<PermanentIdPredicate>();
                    if (!selectedCreatures.isEmpty()) {
                        for (UUID creatureId : selectedCreatures) {
                            alreadySelectedCreatures.add(new PermanentIdPredicate(creatureId));
                        }
                        currentFilter.add(Predicates.or((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 5 - powerSum), (Predicate)Predicates.or(alreadySelectedCreatures)));
                    } else {
                        currentFilter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 5 - powerSum));
                    }
                    if (player.isComputer()) {
                        FilterControlledCreaturePermanent strictFilter = currentFilter.copy();
                        selectedCreatures.stream().forEach(id -> strictFilter.add(Predicates.not((Predicate)new PermanentIdPredicate(id))));
                        target = new TargetPermanent(0, 1, (FilterPermanent)strictFilter, true);
                    } else {
                        target = new TargetPermanent(0, 1, (FilterPermanent)currentFilter, true);
                    }
                    player.chooseTarget(Outcome.BoostCreature, (Target)target, source, game);
                    if (target.getFirstTarget() != null) {
                        if (selectedCreatures.contains(target.getFirstTarget())) {
                            selectedCreatures.remove(target.getFirstTarget());
                            continue;
                        }
                        selectedCreatures.add(target.getFirstTarget());
                        continue;
                    }
                    if (player.isComputer()) {
                        selectionDone = true;
                        continue;
                    }
                    String selected = "Selected: ";
                    for (UUID creatureId : selectedCreatures) {
                        Permanent creature = game.getPermanent(creatureId);
                        if (creature == null) continue;
                        selected = selected + creature.getLogName() + " ";
                    }
                    selectionDone = player.chooseUse(Outcome.Detriment, "Creature selection", selected, "End the selection", "Continue the selection", source, game);
                }
                for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game)) {
                    if (selectedCreatures.contains(creature.getId())) continue;
                    creature.sacrifice(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

