/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.abilities.effects.common.continuous.CantBeSacrificedSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SlicerHiredMuscleUpkeepEffect
extends OneShotEffect {
    SlicerHiredMuscleUpkeepEffect() {
        super(Outcome.GainControl);
        this.staticText = "you may have that player gain control of {this} until end of turn. If you do, untap {this}, goad it, and it can't be sacrificed this turn. If you don't, convert it.";
    }

    private SlicerHiredMuscleUpkeepEffect(SlicerHiredMuscleUpkeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public SlicerHiredMuscleUpkeepEffect copy() {
        return new SlicerHiredMuscleUpkeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(sourcePermanent.getControllerId());
        Player newController = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || newController == null || sourcePermanent == null) {
            return false;
        }
        if (player.chooseUse(this.getOutcome(), source.getRule(), source, game)) {
            game.addEffect(new GainControlTargetEffect(Duration.EndOfTurn, false, newController.getId()).setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game)), source);
            game.processAction();
            sourcePermanent.untap(game);
            game.addEffect(new GoadTargetEffect().setDuration(Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game)), source);
            game.addEffect(new GainAbilityTargetEffect((Ability)new SimpleStaticAbility((Effect)new CantBeSacrificedSourceEffect().setText("This creature can't be sacrificed")), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game)), source);
        } else {
            new TransformSourceEffect().apply(game, source);
        }
        return true;
    }
}

