/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class SlightMalfunctionEffect
extends OneShotEffect {
    SlightMalfunctionEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. When you do, {this} deals 1 damage to each of up to X target creatures, where X is the result";
    }

    private SlightMalfunctionEffect(SlightMalfunctionEffect effect) {
        super((OneShotEffect)effect);
    }

    public SlightMalfunctionEffect copy() {
        return new SlightMalfunctionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 6);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(1), false);
        ability.addTarget((Target)new TargetAnyTarget(0, result));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

