/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.OozeTrampleToken;
import mage.players.Player;

class SlimeAgainstHumanityEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    SlimeAgainstHumanityEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 0/0 green Ooze creature token with trample. Put X +1/+1 counters on it, where X is two plus the total number of cards you own in exile and in your graveyard that are Oozes or are named Slime Against Humanity";
    }

    private SlimeAgainstHumanityEffect(SlimeAgainstHumanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public SlimeAgainstHumanityEffect copy() {
        return new SlimeAgainstHumanityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        OozeTrampleToken token = new OozeTrampleToken();
        token.putOntoBattlefield(1, game, source);
        int graveCount = Optional.ofNullable(game.getPlayer(source.getControllerId())).filter(Objects::nonNull).map(Player::getGraveyard).map(g -> g.count(filter, game)).orElse(0);
        int exileCount = game.getState().getExile().getCardsOwned(game, source.getControllerId()).stream().filter(card -> filter.match(card, game)).mapToInt(x -> 1).sum();
        int xValue = 2 + graveCount + exileCount;
        if (xValue < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(xValue), source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.OOZE.getPredicate(), (Predicate)new NamePredicate("Slime Against Humanity")));
    }
}

