/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class SlithermuseEffect
extends OneShotEffect {
    SlithermuseEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an opponent. If that player has more cards in hand than you, draw cards equal to the difference";
    }

    private SlithermuseEffect(SlithermuseEffect effect) {
        super((OneShotEffect)effect);
    }

    public SlithermuseEffect copy() {
        return new SlithermuseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        if (player != null && permanent != null) {
            Player chosenPlayer;
            TargetOpponent target = new TargetOpponent();
            target.withNotTarget(true);
            if (player.choose(this.outcome, (Target)target, source, game) && (chosenPlayer = game.getPlayer(target.getFirstTarget())) != null) {
                game.informPlayers(permanent.getName() + ": " + player.getLogName() + " has chosen " + chosenPlayer.getLogName());
                int diff = chosenPlayer.getHand().size() - player.getHand().size();
                if (diff > 0) {
                    player.drawCards(diff, source, game);
                }
                return true;
            }
        }
        return false;
    }
}

