/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DevoidAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SlivdraziMonstrosityEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent(SubType.SLIVER, "Slivers");

    public SlivdraziMonstrosityEffect() {
        super(Duration.WhileOnBattlefield, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Slivers you control have devoid";
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            if (!perm.isControlledBy(source.getControllerId())) continue;
            perm.addAbility((Ability)new DevoidAbility(perm.getColor(game)), source.getSourceId(), game);
        }
        return true;
    }

    public SlivdraziMonstrosityEffect copy() {
        return new SlivdraziMonstrosityEffect(this);
    }

    private SlivdraziMonstrosityEffect(SlivdraziMonstrosityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }
}

