/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SlumberingDragonEffect
extends RestrictionEffect {
    SlumberingDragonEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack or block unless it has five or more +1/+1 counters on it";
    }

    private SlumberingDragonEffect(SlumberingDragonEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            return permanent.getCounters(game).getCount(CounterType.P1P1) < 5;
        }
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public SlumberingDragonEffect copy() {
        return new SlumberingDragonEffect(this);
    }
}

