/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.cards.Card;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class SmeltingVatTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterArtifactCard("noncreature artifact cards");
    private final int value;

    SmeltingVatTarget(Ability source) {
        super(0, 2, filter);
        this.value = CardUtil.castStream((Stream)source.getCosts().stream(), SacrificeTargetCost.class).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).mapToInt(MageObject::getManaValue).sum();
    }

    private SmeltingVatTarget(SmeltingVatTarget target) {
        super((TargetCardInLibrary)target);
        this.value = target.value;
    }

    public SmeltingVatTarget copy() {
        return new SmeltingVatTarget(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) return false;
        if (card.getManaValue() + this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum() > this.value) return false;
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

