/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SmirkingSpelljackerEffect
extends OneShotEffect {
    SmirkingSpelljackerEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast the exiled card without paying its mana cost";
    }

    private SmirkingSpelljackerEffect(SmirkingSpelljackerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmirkingSpelljackerEffect copy() {
        return new SmirkingSpelljackerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterCard filter = new FilterCard("card exiled with " + CardUtil.getSourceLogName((Game)game, (Ability)source));
        TargetCardInExile target = new TargetCardInExile(filter, CardUtil.getExileZoneId((Game)game, (Ability)source));
        target.withNotTarget(true);
        controller.choose(Outcome.PlayForFree, (Target)target, source, game);
        new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST).setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget())).apply(game, source);
        return true;
    }
}

