/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SmokeTellerLookFaceDownEffect
extends OneShotEffect {
    SmokeTellerLookFaceDownEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at target face-down creature";
    }

    private SmokeTellerLookFaceDownEffect(SmokeTellerLookFaceDownEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmokeTellerLookFaceDownEffect copy() {
        return new SmokeTellerLookFaceDownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (player == null || mageObject == null) {
            return false;
        }
        Permanent faceDownCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (faceDownCreature == null) {
            return false;
        }
        player.lookAtCards("face down card - " + mageObject.getName(), (Card)faceDownCreature, game);
        return true;
    }
}

