/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class SmokestackEffect
extends OneShotEffect {
    SmokestackEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "that player sacrifices a permanent of their choice for each soot counter on {this}";
    }

    private SmokestackEffect(SmokestackEffect effect) {
        super((OneShotEffect)effect);
    }

    public SmokestackEffect copy() {
        return new SmokestackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player activePlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (activePlayer != null && sourcePermanent != null) {
            int amount;
            TargetSacrifice target;
            int count = sourcePermanent.getCounters(game).getCount(CounterType.SOOT);
            if (count > 0 && (target = new TargetSacrifice(amount = Math.min(count, game.getBattlefield().countAll(StaticFilters.FILTER_PERMANENT, activePlayer.getId(), game)), StaticFilters.FILTER_PERMANENT)).canChoose(activePlayer.getId(), source, game)) {
                while (!target.isChosen(game) && target.canChoose(activePlayer.getId(), source, game) && activePlayer.canRespond()) {
                    activePlayer.choose(Outcome.Sacrifice, (Target)target, source, game);
                }
                for (int idx = 0; idx < target.getTargets().size(); ++idx) {
                    Permanent permanent = game.getPermanent((UUID)target.getTargets().get(idx));
                    if (permanent == null) continue;
                    permanent.sacrifice(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

