/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.RollDieType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.RollDieEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SnickeringSquirrelEffect
extends ReplacementEffectImpl {
    SnickeringSquirrelEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may tap {this} to increase the result of a die any player rolled by 1";
    }

    private SnickeringSquirrelEffect(SnickeringSquirrelEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Player dieRoller = game.getPlayer(event.getPlayerId());
        if (controller == null || dieRoller == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || permanent.isTapped()) {
            return false;
        }
        if (controller.chooseUse(Outcome.AIDontUseIt, "Tap this to increase the result of a die (" + event.getAmount() + ") " + dieRoller.getName() + " rolled by 1?", source, game)) {
            permanent.tap(source, game);
            ((RollDieEvent)event).incResultModifier(1);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ROLL_DIE && ((RollDieEvent)event).getRollDieType() == RollDieType.NUMERICAL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public SnickeringSquirrelEffect copy() {
        return new SnickeringSquirrelEffect(this);
    }
}

