/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SnortEffect
extends OneShotEffect {
    SnortEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may discard their hand and draw five cards. Then {this} deals 5 damage to each opponent who discarded their hand this way";
    }

    private SnortEffect(SnortEffect effect) {
        super((OneShotEffect)effect);
    }

    public SnortEffect copy() {
        return new SnortEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<UUID> toDiscard = new HashSet<UUID>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player2 = game.getPlayer(playerId);
            if (player2 == null) continue;
            if (player2.chooseUse(Outcome.DrawCard, source.isControlledBy(playerId) ? "Discard your hand and draw five cards?" : "Discard your hand, draw five cards, and be dealt 5 damage?", source, game)) {
                game.informPlayers(player2.getLogName() + " chooses to discard and draw five");
                toDiscard.add(playerId);
                continue;
            }
            game.informPlayers(player2.getLogName() + " chooses not to discard");
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Optional.ofNullable(playerId).filter(toDiscard::contains).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> {
                player.discard(player.getHand(), false, source, game);
                player.drawCards(5, source, game);
            });
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Optional.ofNullable(playerId).filter(toDiscard::contains).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.damage(5, source, game));
        }
        return !toDiscard.isEmpty();
    }
}

