/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SnowMercyCost
extends CostImpl {
    SnowMercyCost() {
        this.text = "{T}, {Q}, {T}, {Q}, {T}";
    }

    private SnowMercyCost(SnowMercyCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null && !permanent.isTapped() && permanent.tap(source, game) && permanent.isTapped() && permanent.untap(game) && !permanent.isTapped() && permanent.tap(source, game) && permanent.isTapped() && permanent.untap(game) && !permanent.isTapped() && permanent.tap(source, game)) {
            this.paid = true;
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            return !permanent.isTapped();
        }
        return false;
    }

    public SnowMercyCost copy() {
        return new SnowMercyCost(this);
    }
}

