/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SokratesAthenianTeacherEffect
extends PreventionEffectImpl {
    static final String rule = "If this creature would deal combat damage to a player, prevent that damage. This creature's controller and that player each draw half that many cards, rounded down.";

    SokratesAthenianTeacherEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, true, false);
        this.staticText = rule;
    }

    private SokratesAthenianTeacherEffect(SokratesAthenianTeacherEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public SokratesAthenianTeacherEffect copy() {
        return new SokratesAthenianTeacherEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getSourceId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player damagedPlayer;
        Player controller;
        int amount = event.getAmount() / 2;
        this.preventDamageAction(event, source, game);
        Permanent creature = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (creature != null && (controller = game.getPlayer(creature.getControllerId())) != null) {
            controller.drawCards(amount, source, game);
        }
        if ((damagedPlayer = game.getPlayer(event.getTargetId())) != null) {
            damagedPlayer.drawCards(amount, source, game);
        }
        return false;
    }
}

