/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Iterator;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SoldeviDiggerEffect
extends OneShotEffect {
    SoldeviDiggerEffect() {
        super(Outcome.Benefit);
        this.staticText = "put the top card of your graveyard on the bottom of your library";
    }

    private SoldeviDiggerEffect(SoldeviDiggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SoldeviDiggerEffect copy() {
        return new SoldeviDiggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card topCard = null;
            Iterator iterator = controller.getGraveyard().getCards(game).iterator();
            while (iterator.hasNext()) {
                Card card;
                topCard = card = (Card)iterator.next();
            }
            if (topCard != null) {
                return controller.moveCardToLibraryWithInfo(topCard, source, game, Zone.GRAVEYARD, false, true);
            }
            return true;
        }
        return false;
    }
}

