/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SolidarityOfHeroesEffect
extends OneShotEffect {
    SolidarityOfHeroesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose any number of target creatures. Double the number of +1/+1 counters on each of them";
    }

    private SolidarityOfHeroesEffect(SolidarityOfHeroesEffect effect) {
        super((OneShotEffect)effect);
    }

    public SolidarityOfHeroesEffect copy() {
        return new SolidarityOfHeroesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                int existingCounters;
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null || (existingCounters = permanent.getCounters(game).getCount(CounterType.P1P1)) <= 0) continue;
                permanent.addCounters(CounterType.P1P1.createInstance(existingCounters), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

