/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SongOfBloodTriggeredAbility
extends DelayedTriggeredAbility {
    private final int booster;

    SongOfBloodTriggeredAbility(int booster) {
        super((Effect)new BoostTargetEffect(booster, 0, Duration.EndOfTurn), Duration.EndOfTurn, false);
        this.booster = booster;
    }

    private SongOfBloodTriggeredAbility(SongOfBloodTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.booster = ability.booster;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public SongOfBloodTriggeredAbility copy() {
        return new SongOfBloodTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature attacks this turn, it gets +" + this.booster + "/0 until end of turn.";
    }
}

