/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SorinImperiousBloodlordEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.target.common.TargetControlledCreaturePermanent;

public final class SorinImperiousBloodlord
extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent(SubType.VAMPIRE, "a Vampire");
    private static final FilterCard filter2 = new FilterCreatureCard("a Vampire creature card");

    public SorinImperiousBloodlord(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{2}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.SORIN);
        this.setStartingLoyalty(4);
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new SorinImperiousBloodlordEffect(), 1);
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        this.addAbility((Ability)ability);
        ReflexiveTriggeredAbility triggeredAbility = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(3), false, "{this} deals 3 damage to any target and you gain 3 life");
        triggeredAbility.addEffect((Effect)new GainLifeEffect(3));
        triggeredAbility.addTarget((Target)new TargetAnyTarget());
        this.addAbility((Ability)new LoyaltyAbility((Effect)new DoWhenCostPaid(triggeredAbility, (Cost)new SacrificeTargetCost((FilterPermanent)filter), "Sacrifice a Vampire?"), 1));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new PutCardFromHandOntoBattlefieldEffect(filter2), -3));
    }

    private SorinImperiousBloodlord(SorinImperiousBloodlord card) {
        super((CardImpl)card);
    }

    public SorinImperiousBloodlord copy() {
        return new SorinImperiousBloodlord(this);
    }

    static {
        filter2.add((Predicate)SubType.VAMPIRE.getPredicate());
    }
}

