/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SorinTheMirthlessEffect
extends OneShotEffect {
    SorinTheMirthlessEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top card of your library. You may reveal that card and put it into your hand. If you do, you lose life equal to its mana value";
    }

    private SorinTheMirthlessEffect(SorinTheMirthlessEffect effect) {
        super((OneShotEffect)effect);
    }

    public SorinTheMirthlessEffect copy() {
        return new SorinTheMirthlessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card topCard = controller.getLibrary().getFromTop(game);
        if (topCard != null) {
            CardsImpl cards = new CardsImpl(topCard);
            controller.lookAtCards(source, null, (Cards)cards, game);
            if (controller.chooseUse(this.outcome, "Reveal " + topCard.getName() + " and put it into your hand?", source, game)) {
                controller.revealCards(source, (Cards)cards, game);
                controller.moveCards((Cards)cards, Zone.HAND, source, game);
                controller.loseLife(topCard.getManaValue(), game, source, false);
            }
        }
        return true;
    }
}

