/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.BlockerDeclaredEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class SorrowsPathSwitchBlockersEffect
extends OneShotEffect {
    SorrowsPathSwitchBlockersEffect() {
        super(Outcome.Detriment);
        this.staticText = "Choose two target blocking creatures an opponent controls. If each of those creatures could block all creatures that the other is blocking, remove both of them from combat. Each one then blocks all creatures the other was blocking";
    }

    private SorrowsPathSwitchBlockersEffect(SorrowsPathSwitchBlockersEffect effect) {
        super((OneShotEffect)effect);
    }

    public SorrowsPathSwitchBlockersEffect copy() {
        return new SorrowsPathSwitchBlockersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        List targets = ((Target)source.getTargets().get(0)).getTargets();
        if (controller != null && targets != null) {
            Permanent blocker1 = game.getPermanent((UUID)targets.get(0));
            Permanent blocker2 = game.getPermanent((UUID)targets.get(1));
            if (blocker1 != null && blocker2 != null) {
                Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
                CombatGroup chosenGroup1 = this.findBlockingGroup(blocker1, game);
                CombatGroup chosenGroup2 = this.findBlockingGroup(blocker2, game);
                HashSet<Permanent> attackers1 = new HashSet<Permanent>();
                HashSet<Permanent> attackers2 = new HashSet<Permanent>();
                boolean blockPossible = false;
                if (chosenGroup1 != null && chosenGroup2 != null) {
                    boolean bl = blockPossible = this.getRestrictions(chosenGroup1, blocker2, attackers1, sourcePermanent, controller, game) && this.getRestrictions(chosenGroup2, blocker1, attackers2, sourcePermanent, controller, game);
                }
                if (!blockPossible) {
                    return true;
                }
                blocker1.removeFromCombat(game);
                blocker2.removeFromCombat(game);
                this.reassignBlocker(blocker1, attackers2, game, source);
                this.reassignBlocker(blocker2, attackers1, game, source);
                HashSet morSet = new HashSet();
                attackers1.stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(morSet::add);
                attackers2.stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(morSet::add);
                String key = UUID.randomUUID().toString();
                game.getState().setValue("becameBlocked_" + key, morSet);
                game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.BATCH_BLOCK_NONCOMBAT, (UUID)source.getSourceId(), (Ability)source, (UUID)source.getControllerId(), (String)key, (int)0));
                return true;
            }
        }
        return false;
    }

    private CombatGroup findBlockingGroup(Permanent blocker, Game game) {
        if (game.getCombat().blockingGroupsContains(blocker.getId())) {
            for (CombatGroup group : game.getCombat().getBlockingGroups()) {
                if (!group.getBlockers().contains(blocker.getId())) continue;
                return group;
            }
        }
        return game.getCombat().findGroupOfBlocker(blocker.getId());
    }

    private boolean getRestrictions(CombatGroup chosenGroup, Permanent blocker, Set<Permanent> attackers, Permanent sourcePermanent, Player controller, Game game) {
        for (UUID attackerId : chosenGroup.getAttackers()) {
            Permanent attacker = game.getPermanent(attackerId);
            if (attacker == null) continue;
            if (blocker.canBlock(attackerId, game) && (blocker.getMaxBlocks() == 0 || chosenGroup.getAttackers().size() <= blocker.getMaxBlocks())) {
                attackers.add(attacker);
                continue;
            }
            game.informPlayer(controller, "Illegal block detected (" + blocker.getName() + "), effect of " + sourcePermanent.getName() + " doesn't apply.");
            return false;
        }
        return true;
    }

    private void reassignBlocker(Permanent blocker, Set<Permanent> attackers, Game game, Ability source) {
        for (Permanent attacker : attackers) {
            CombatGroup group = game.getCombat().findGroup(attacker.getId());
            if (group == null) continue;
            group.addBlockerToGroup(blocker.getId(), blocker.getControllerId(), game);
            game.getCombat().addBlockingGroup(blocker.getId(), attacker.getId(), blocker.getControllerId(), game);
            game.fireEvent((GameEvent)new BlockerDeclaredEvent(attacker.getId(), blocker.getId(), blocker.getControllerId()));
        }
        game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.CREATURE_BLOCKS, (UUID)blocker.getId(), (Ability)source, null));
    }
}

