/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class SotheraTheSupervoidExileEffect
extends OneShotEffect {
    SotheraTheSupervoidExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent chooses a creature they control and exiles it";
    }

    private SotheraTheSupervoidExileEffect(SotheraTheSupervoidExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public SotheraTheSupervoidExileEffect copy() {
        return new SotheraTheSupervoidExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, playerId, source, game, 1)) {
                return false;
            }
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withChooseHint("to exile");
            target.withNotTarget(true);
            player.choose(Outcome.Exile, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            player.moveCardsToExile((Card)permanent, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        }
        return true;
    }
}

