/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulEchoReplacementEffect
extends ReplacementEffectImpl {
    SoulEchoReplacementEffect() {
        super(Duration.UntilYourNextUpkeepStep, Outcome.PreventDamage);
    }

    private SoulEchoReplacementEffect(SoulEchoReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        int damage = damageEvent.getAmount();
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null) {
            permanent.removeCounters(CounterType.ECHO.createInstance(damage), source, game);
            game.informPlayers(controller.getLogName() + ": " + damage + " damage replaced with " + permanent.getLogName());
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getControllerId());
    }

    public SoulEchoReplacementEffect copy() {
        return new SoulEchoReplacementEffect(this);
    }
}

